#include "FileManager.h"
#include "Functors.h"
#include <algorithm>
#include <string>
#include <exception>
#include <vector>
#include <ctime>

FileManager::FileManager()  {}

FileManager::~FileManager() {}

void FileManager::createData(std::ofstream& out_stream) {
        if (!out_stream.is_open()) {
                throw std::runtime_error("File is not opened");
	}
	srand(time(nullptr));
	for (int i = 0; i < 100; i++) {
                int new_elem = rand() % 101 - 50;
            out_stream << std::to_string(new_elem) + " ";
	}
}

void FileManager::createData(std::ostream_iterator<int> it) {
	srand(time(nullptr));
        std::vector<int> temp_vec(100);
        std::generate(temp_vec.begin(), temp_vec.end(), []() {
		return rand() % 101 - 50;
		}
	);

        std::copy(temp_vec.begin(), temp_vec.end(), it);
}

void FileManager::modify(std::istream_iterator<int> begin_it, std::istream_iterator<int> end_it, std::ostream_iterator<int> beg_out) {
        int sum = 0;
        unsigned count = 0;
        std::vector<int> buf(100);
        std::copy(begin_it,end_it,buf.begin());

        std::for_each(buf.begin(), buf.end(), [&sum, &count](int cur) {
            sum += cur;
            ++count;
        }
        );

        if(count == 0)
        {
            return;
        }

        float mean = sum / count;

        std::transform(buf.begin(), buf.end() , beg_out, [&mean](const auto &elem) {
            if (abs(elem) % 2) {
             return elem/mean;}
             return elem; }
        );
}
